<?php

/*
App::uses('User', 'Model');
$user = new User();
$user->id = 1154;
$user->set(array(
    'links' => 1
));
$user->save();
*/

?>

<!-- BEGIN DASHBOARD STATS -->
<div class="row">

    <div class="col-lg-3 col-xs-6">
        <!-- small box -->
        <div class="small-box bg-aqua">
            <div class="inner">
                <h3><?php echo $totalLinks; ?></h3>
                <p><?php echo __('Total Links') ?></p>
            </div>
            <div class="icon">
                <i class="fa fa-link"></i>
            </div>
            <a href="<?php echo $this->Html->url(array( 'controller' => 'links', 'action' => 'index' )); ?>" class="small-box-footer">
                <?php echo __('Manage Links') ?> <i class="fa fa-arrow-circle-right"></i>
            </a>
        </div>
    </div><!-- ./col -->

    <div class="col-lg-3 col-xs-6">
        <!-- small box -->
        <div class="small-box bg-green">
            <div class="inner">
                <h3><?php echo intval($totalHits); ?></h3>
                <p><?php echo __('Total Hits') ?></p>
            </div>
            <div class="icon">
                <i class="fa fa-bar-chart-o"></i>
            </div>
            <a href="<?php echo $this->Html->url(array( 'controller' => 'stats', 'action' => 'location' )); ?>" class="small-box-footer">
                <?php echo __('View more') ?> <i class="fa fa-arrow-circle-right"></i>
            </a>
        </div>
    </div><!-- ./col -->

    <div class="col-lg-3 col-xs-6">
        <!-- small box -->
        <div class="small-box bg-yellow">
            <div class="inner">
                <h3><?php echo $totalUsers; ?></h3>
                <p><?php echo __('Total Users') ?></p>
            </div>
            <div class="icon">
                <i class="fa fa-users"></i>
            </div>
            <a href="<?php echo $this->Html->url(array( 'controller' => 'users', 'action' => 'index' )); ?>" class="small-box-footer">
                <?php echo __('View more') ?> <i class="fa fa-arrow-circle-right"></i>
            </a>
        </div>
    </div><!-- ./col -->

    <div class="col-lg-3 col-xs-6">
        <!-- small box -->
        <div class="small-box bg-red">
            <div class="inner">
                <h3><?php echo $this->Session->read('Auth.User.account_type'); ?></h3>
                <p><?php echo __('Account Type') ?> </p>
            </div>
            <div class="icon">
                <i class="fa fa-plus-square"></i>
            </div>
            <a href="<?php echo $this->Html->url(array( 'controller' => 'plans', 'action' => 'index' )); ?>" class="small-box-footer">
                <?php echo __('Upgrade') ?> <i class="fa fa-arrow-circle-right"></i>
            </a>
        </div>
    </div><!-- ./col -->

</div>


<!-- BEGIN PAGE CONTENT-->
<div class="row">
    <div class="col-sm-12">

        <!-- Info box -->
        <div class="box box-info">
            <div class="box-header">
                <i class="glyphicon glyphicon-stats"></i> <h3 class="box-title">Clicks on last 30 days</h3>
            </div>
            <div class="box-body">
                <div class="chart" id="last-month-hits" style="position: relative; height: 300px; width: 100%;"></div>
            </div><!-- /.box-body -->
        </div><!-- /.box -->



        <script>
            jQuery( document ).ready( function () {
                new Morris.Line( {
                    element: 'last-month-hits',
                    resize: true,
                    data: [
<?php
$last30days = array();
for ($i = 30; $i > 0; $i--) {
    $last30days[date('d-m-Y', strtotime('-' . $i . ' days'))] = 0;
}
foreach ($linksStats as $linksStat) {
    if (empty($linksStat[0]["statDateCount"])) {
        $linksStat[0]["statDateCount"] = 0;
    }
    $last30days[$linksStat[0]["statDate"]] = $linksStat[0]["statDateCount"];
}

foreach ($last30days as $key => $value) {
    $date = date("Y-m-d", strtotime($key));
    echo '{date: "' . $date . '", clicks: ' . $value . '},';
}
?>
                    ],
                    xkey: 'date',
                    xLabels: 'day',
                    ykeys: [ 'clicks' ],
                    labels: [ 'Clicks' ],
                    lineWidth: 2,
                    hideHover: 'auto',
                    smooth: false
                } );
            } );
        </script>

        <div class="row">
            <div class="col-sm-6">



                <!-- Info box -->
                <div class="box box-solid box-primary">
                    <div class="box-header">
                        <span class="glyphicon glyphicon-link"></span> <h3 class="box-title">New Short URLs</h3>
                    </div>
                    <div class="box-body">
                        <ul class="list-group" style="height: 300px; overflow: auto;">
                            <?php
                            foreach ($newLinks as $newLink) {
                                $short_link = $this->Html->url('/'.$newLink['Link']['alias'], true);
                                
                                $link_title = $newLink["Link"]["title"];
                                if (empty($link_title)) {
                                    $link_title = $short_link;
                                }
                                ?>
                            <li class="list-group-item">
                                <h4 class="list-group-item-heading"><a href="<?php echo h($newLink["Link"]["long_url"]);
                                ?>" target="_blank"><i class="fa fa-angle-double-right"></i> <?php echo h($link_title);
                                ?></a></h4>
                                <div class="list-group-item-text">
                                    <small class="text-muted">
                                        <i class="fa fa-calendar"></i> <?php echo $this->Time->format($newLink['Link']['created'], '%d-%m-%y');
                                ?> - <a target="_blank" href="<?php echo h($newLink['Link']['long_url']);
                                ?>"><?php echo strtoupper(parse_url($newLink['Link']['long_url'], PHP_URL_HOST));
                                ?></a> - <i class="fa fa-hand-o-up"></i> <?php echo $newLink['Link']['clicks'];
                                ?> clicks - <i class="fa fa-user"></i> <?php echo $newLink['User']['username'];
                                ?>
                                    </small>
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <input type="text" class="form-control input-sm" id="" value = "<?php echo $short_link;
                                ?>" readonly onfocus="javascript:this.select()">
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="text-right">
                                                    <?php echo $this->Html->link('<i class="fa fa-edit"></i> Edit', array('controller' => 'links', 'action' => 'edit', $newLink['Link']['id']), array('escape' => false, 'class' => 'btn btn-primary btn-xs'));
                                ?>

                                                    <?php
                                                    echo $this->Form->postLink(
                                                        '<i class="fa fa-trash-o"></i> Delete',
                                                        array('controller' => 'links', 'action' => 'delete', $newLink['Link']['id']),
                                                        array('escape' => false, 'class' => 'btn btn-danger btn-xs', 'confirm' => 'Are you sure?')
                                                    );
                                ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                                <?php

                            }
                            unset($newLink);
                            ?>
                        </ul>
                    </div><!-- /.box-body -->
                </div><!-- /.box -->


            </div>
            <div class="col-sm-6">

                <!-- Info box -->
                <div class="box box-solid box-success">
                    <div class="box-header">
                        <span class="glyphicon glyphicon-fire"></span> <h3 class="box-title">Popular Short URLs</h3>
                    </div>
                    <div class="box-body">
                        <ul class="list-group" style="height: 300px; overflow: auto;">
                            <?php
                            foreach ($popularLinks as $popularLink) {
                                $short_link = $this->Html->url('/'.$popularLink['Link']['alias'], true);
                                
                                $link_title = $popularLink["Link"]["title"];
                                if (empty($link_title)) {
                                    $link_title = $short_link;
                                }
                                ?>
                            <li class="list-group-item">
                                <h4 class="list-group-item-heading"><a href="<?php echo h($popularLink["Link"]["long_url"]);
                                ?>" target="_blank"><i class="fa fa-angle-double-right"></i> <?php echo h($link_title);
                                ?></a></h4>
                                <div class="list-group-item-text">
                                    <small class="text-muted">
                                        <i class="fa fa-calendar"></i> <?php echo $this->Time->format($popularLink['Link']['created'], '%d-%m-%y');
                                ?> - <a target="_blank" href="<?php echo h($popularLink['Link']['long_url']);
                                ?>"><?php echo strtoupper(parse_url($popularLink['Link']['long_url'], PHP_URL_HOST));
                                ?></a> - <i class="fa fa-hand-o-up"></i> <?php echo $popularLink['Link']['clicks'];
                                ?> clicks - <i class="fa fa-user"></i> <?php echo $popularLink['User']['username'];
                                ?>
                                    </small>
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <input type="text" class="form-control input-sm" id="copylink" value = "<?php echo $short_link;
                                ?>" readonly onfocus="javascript:this.select()">
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="text-right">
                                                    <?php echo $this->Html->link('<i class="fa fa-edit"></i> Edit', array('controller' => 'links', 'action' => 'edit', $popularLink['Link']['id']), array('escape' => false, 'class' => 'btn btn-primary btn-xs'));
                                ?>

                                                    <?php
                                                    echo $this->Form->postLink(
                                                        '<i class="fa fa-trash-o"></i> Delete',
                                                        array('controller' => 'links', 'action' => 'delete', $popularLink['Link']['id']),
                                                        array('escape' => false, 'class' => 'btn btn-danger btn-xs', 'confirm' => 'Are you sure?')
                                                    );
                                ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                                <?php

                            }
                            unset($popularLink);
                            ?>
                        </ul>
                    </div><!-- /.box-body -->
                </div><!-- /.box -->    


            </div>
        </div>

        <div class="row">
            <div class="col-sm-6">
                <!-- Info box -->
                <div class="box box-solid box-info">
                    <div class="box-header">
                        <i class="fa fa-users"></i> <h3 class="box-title">Latest Users</h3>
                    </div>
                    <div class="box-body">
                        <ul class="list-group" style="height: 300px; overflow: auto;">
                            <?php
                            foreach ($newUsers as $newUser) {
                                ?>
                            <li class="list-group-item">
                                <h4 class="list-group-item-heading"><i class="fa fa-user"></i> <?php echo $this->Html->Link($newUser['User']['username'], array('controller' => 'users', 'action' => 'view', $newUser['User']['id']));
                                ?></h4>
                                <div class="list-group-item-text">
                                    <small class="text-muted">
                                        <i class="fa fa-calendar"></i> <?php echo $this->Time->format($newUser['User']['created'], '%d-%m-%y');
                                ?>
                                    </small>
                                </div>
                            </li>
                                <?php

                            }
                            unset($newLink);
                            ?>
                        </ul>
                    </div><!-- /.box-body -->
                </div><!-- /.box -->
            </div>
            <div class="col-sm-6">
                <!-- Info box -->
                <div class="box box-solid box-info">
                    <div class="box-header">
                        <i class="fa fa-users"></i> <h3 class="box-title">Active Users</h3>
                    </div>
                    <div class="box-body">
                        <ul class="list-group" style="height: 300px; overflow: auto;">
                            <?php
                            foreach ($popularUsers as $popularUser) {
                                ?>
                            <li class="list-group-item">
                                <h4 class="list-group-item-heading"><i class="fa fa-user"></i> <?php echo $this->Html->Link($popularUser['User']['username'], array('controller' => 'users', 'action' => 'view', $popularUser['User']['id']));
                                ?></h4>
                                <div class="list-group-item-text">
                                    <small class="text-muted">
                                        <i class="fa fa-calendar"></i> <?php echo $this->Time->format($popularUser['User']['created'], '%d-%m-%y');
                                ?>
                                    </small>
                                </div>
                            </li>
                                <?php

                            }
                            unset($popularUser);
                            ?>
                        </ul>
                    </div><!-- /.box-body -->
                </div><!-- /.box -->
            </div>
        </div>

    </div>
</div>
<!-- END PAGE CONTENT-->
